SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";



CREATE TABLE `backup_record` (
  `id` int(15) NOT NULL,
  `detail` varchar(255) NOT NULL,
  `school_id` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `j_nems_accesskey_request`
--

CREATE TABLE `j_nems_accesskey_request` (
  `id` int(10) NOT NULL,
  `date_request` varchar(100) DEFAULT NULL,
  `test_id` varchar(50) DEFAULT NULL,
  `student_id` varchar(50) DEFAULT NULL,
  `enter_key` varchar(50) DEFAULT NULL,
  `status` varchar(50) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `j_nems_deadline`
--

CREATE TABLE `j_nems_deadline` (
  `id` int(10) NOT NULL,
  `status` varchar(100) DEFAULT NULL,
  `post_id` varchar(100) DEFAULT NULL,
  `com_id` varchar(100) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `j_nems_instruction`
--

CREATE TABLE `j_nems_instruction` (
  `id` int(10) NOT NULL,
  `instruction` text NOT NULL,
  `com_id` varchar(50) DEFAULT NULL,
  `post_id` varchar(100) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `j_nems_limit`
--

CREATE TABLE `j_nems_limit` (
  `id` int(10) NOT NULL,
  `percenta` varchar(100) NOT NULL,
  `com_id` varchar(50) NOT NULL,
  `post_id` varchar(100) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `j_nems_post`
--

CREATE TABLE `j_nems_post` (
  `id` int(10) NOT NULL,
  `post_name` varchar(255) NOT NULL,
  `detail` text NOT NULL,
  `com_id` varchar(50) NOT NULL,
  `test_type` varchar(20) DEFAULT NULL,
  `num_attempt` varchar(50) NOT NULL,
  `user_id` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `j_nems_question`
--

CREATE TABLE `j_nems_question` (
  `id` int(10) NOT NULL,
  `test_id` varchar(20) DEFAULT NULL,
  `question` text,
  `question_img` varchar(255) NOT NULL,
  `optionA` varchar(20) NOT NULL,
  `optionA_detail` text,
  `optionA_img` varchar(255) NOT NULL,
  `optionB` varchar(20) DEFAULT NULL,
  `optionB_detail` text,
  `optionB_img` varchar(255) NOT NULL,
  `optionC` varchar(20) DEFAULT NULL,
  `optionC_detail` text,
  `optionC_img` varchar(255) NOT NULL,
  `optionD` varchar(20) DEFAULT NULL,
  `optionD_detail` text,
  `optionD_img` varchar(255) NOT NULL,
  `correct_option` varchar(20) DEFAULT NULL,
  `correct_option_detail` text,
  `ans_img` varchar(255) NOT NULL,
  `com_id` varchar(50) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `j_nems_register`
--

CREATE TABLE `j_nems_register` (
  `id` int(10) NOT NULL,
  `email` varchar(200) NOT NULL,
  `password` varchar(200) NOT NULL,
  `date_created` varchar(100) NOT NULL,
  `test_date` varchar(100) NOT NULL,
  `surname` varchar(255) NOT NULL,
  `othername` varchar(255) NOT NULL,
  `gender` varchar(50) NOT NULL,
  `dob` varchar(50) NOT NULL,
  `phone` varchar(50) NOT NULL,
  `address` text NOT NULL,
  `state_of_origin` varchar(255) NOT NULL,
  `sch_attended` text NOT NULL,
  `qualification_field_of_study` varchar(255) NOT NULL,
  `year_of_graduation` varchar(200) NOT NULL,
  `post_apply_for` varchar(255) NOT NULL,
  `status` varchar(10) NOT NULL,
  `com_id` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `j_nems_result`
--

CREATE TABLE `j_nems_result` (
  `id` int(10) NOT NULL,
  `user_email` varchar(255) NOT NULL,
  `question_id` varchar(10) NOT NULL,
  `user_answer` varchar(10) NOT NULL,
  `test_summary` text NOT NULL,
  `com_id` varchar(50) NOT NULL,
  `date_taken` varchar(40) DEFAULT NULL,
  `batch_num_val` varchar(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `j_nems_result_list`
--

CREATE TABLE `j_nems_result_list` (
  `id` int(10) NOT NULL,
  `date_taken` varchar(20) DEFAULT NULL,
  `test_name` varchar(255) DEFAULT NULL,
  `test_id` varchar(20) DEFAULT NULL,
  `student_id` varchar(20) DEFAULT NULL,
  `batch_num` varchar(20) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `j_nems_timer`
--

CREATE TABLE `j_nems_timer` (
  `id` int(10) NOT NULL,
  `time_set` varchar(100) DEFAULT NULL,
  `post_id` varchar(100) DEFAULT NULL,
  `com_id` varchar(100) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `j_pin`
--

CREATE TABLE `j_pin` (
  `id` int(10) NOT NULL,
  `pin` varchar(50) NOT NULL,
  `batch` varchar(10) NOT NULL,
  `status` varchar(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `j_pin`
--

INSERT INTO `j_pin` (`id`, `pin`, `batch`, `status`) VALUES
(1, 'fkMfmHMoD2', '1', ''),
(2, '92TivVuZVg', '1', ''),
(3, 'g21LyVRFdD', '1', ''),
(4, '2FABGZvQln', '1', ''),
(5, 'kM90SqGDwc', '1', ''),
(6, 'yDqWzUKPhK', '2', ''),
(7, 'RchT8xExoN', '2', ''),
(8, '0qZuqLLxwg', '2', ''),
(9, '3qmaI8xa56', '2', ''),
(10, 'bu0lQSPhEv', '2', ''),
(11, 'nVb81HwXBC', '2', ''),
(12, 'hGr7xzobTj', '2', ''),
(13, 'Ohs7wmNJTV', '2', ''),
(14, '1lKUIHrOZ0', '2', ''),
(15, 'NzpZbG6Qr6', '2', ''),
(16, 'DkUj6Cqg7s', '2', ''),
(17, 'kqL4uMD9dM', '2', ''),
(18, 'PWnpV9j810', '2', ''),
(19, 'RUJdne8ZG2', '2', ''),
(20, 'O49OTFBwVu', '2', ''),
(21, 'nD2Ll7OcOs', '2', ''),
(22, 'l2FAdYd0xf', '2', ''),
(23, 'kGTyl4n858', '2', ''),
(24, 'AGUmCrFH47', '2', ''),
(25, 'HE1WQ94CrG', '2', ''),
(26, 'jmlclUUcft', '2', ''),
(27, 'WCDLPXA0na', '2', ''),
(28, 'HVXI4Iozi8', '2', ''),
(29, '2dsmKBa9Qc', '2', ''),
(30, 'uGbZ3I6rVr', '2', ''),
(31, 'svIAAFvnjS', '2', ''),
(32, 'Uw0DZfvSmf', '2', ''),
(33, '957MNeQxLM', '2', ''),
(34, 'DKUI68AtjU', '2', ''),
(35, 'C3SMmUTZE1', '2', ''),
(36, 'WeQQ7KMl0f', '2', ''),
(37, 'N0JWKNRyXa', '2', ''),
(38, 'vji7eV54aC', '2', ''),
(39, 'a2S6UtuA9l', '2', ''),
(40, 'yPd7c0XL0R', '2', ''),
(41, 'IK3Al2YWb7', '2', ''),
(42, 'O74WcPmYej', '2', ''),
(43, 'SdthZ52WxA', '2', ''),
(44, 'v1QbZKLQ4P', '2', ''),
(45, 'E1QulIUram', '2', ''),
(46, 'lUZWLB9WfK', '2', ''),
(47, 'uio4lviMzw', '2', ''),
(48, 'yAuOfJYmYV', '2', ''),
(49, 'mCQntzqOGF', '2', ''),
(50, 'QrOTEZdHYG', '2', ''),
(51, 'K4peIt1R0S', '2', ''),
(52, 'qhVKIIl3tS', '2', ''),
(53, 'BgN0wliMtL', '2', ''),
(54, '2sivDKj1aR', '2', ''),
(55, 'ohfvRLXVAq', '2', ''),
(56, 'TPSK8rBGis', '2', ''),
(57, '6It7dOe8hq', '2', ''),
(58, 'HJayrCbDz1', '2', ''),
(59, 'cFGFx5RK3T', '2', ''),
(60, 'G06xhEwZdp', '2', ''),
(61, 'DIBtjH1BSo', '2', ''),
(62, 'zZbMQmzjWW', '2', ''),
(63, 'TYrques3b2', '2', ''),
(64, 'zxmSS6PIYs', '2', ''),
(65, 'W1WPxLoWYq', '2', ''),
(66, 'pZ6WAIeN1k', '2', ''),
(67, 'eYiysVwBIC', '2', ''),
(68, 'icnxGyhDjo', '2', ''),
(69, 'LofVGL6Tmf', '2', ''),
(70, 'XuFMprVPyY', '2', ''),
(71, 'ZoZOcVO9on', '2', ''),
(72, 'BIVfsKDuYW', '2', ''),
(73, 'RygwssTdLC', '2', ''),
(74, 'XeD24inaiC', '2', ''),
(75, 'SZgVsY3qY4', '2', ''),
(76, 'fRKLWqD0KQ', '2', ''),
(77, 'ZhJlEyvEXj', '2', ''),
(78, 'aXKuj0mz0Z', '2', ''),
(79, 'FwSE0P0cbr', '2', ''),
(80, 'YmAPSl2XkS', '2', ''),
(81, 'TjqaYQJXE2', '2', ''),
(82, 'lqKRTkCLqR', '2', ''),
(83, '7JzKyepeOe', '2', ''),
(84, 'xZcc2gA5wM', '2', ''),
(85, 'jo4Kd4hSDA', '2', ''),
(86, 'eopUy1UwjY', '2', ''),
(87, 'Xn6YTX2eAd', '2', ''),
(88, 'GtlC9V292i', '2', ''),
(89, '0hqN5YUaDG', '2', ''),
(90, 'ABtp3PXAp4', '2', ''),
(91, 'Wce3KICZf7', '2', ''),
(92, 'aALRY48TDa', '2', ''),
(93, 'JJf6minzp5', '2', ''),
(94, '9NG49vxHsV', '2', ''),
(95, 'PXGLTiUezH', '2', ''),
(96, 'K4cDgtD44a', '2', ''),
(97, 'dtgoNOrQHy', '2', ''),
(98, 'FJMFzOoCdg', '2', ''),
(99, 'mndP2qFIhI', '2', ''),
(100, '9EpJLRhq62', '2', ''),
(101, 'ehgq7fPJgO', '2', ''),
(102, 'UaxW4tg5rQ', '2', ''),
(103, 'ifB1YRDc8U', '2', ''),
(104, '978SdZPHsw', '2', ''),
(105, 'wSXW5mjZRD', '2', '');

-- --------------------------------------------------------

--
-- Table structure for table `nems_class`
--

CREATE TABLE `nems_class` (
  `class_id` int(10) NOT NULL,
  `name` varchar(255) NOT NULL,
  `school_id` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `nems_class_subject`
--

CREATE TABLE `nems_class_subject` (
  `cs_id` int(15) NOT NULL,
  `class_id` varchar(255) DEFAULT NULL,
  `subject_id` varchar(255) DEFAULT NULL,
  `school_id` varchar(255) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `nems_message`
--

CREATE TABLE `nems_message` (
  `id` int(10) NOT NULL,
  `date_sent` varchar(10) DEFAULT NULL,
  `recipient_id` varchar(10) DEFAULT NULL,
  `recipient_type` varchar(10) DEFAULT NULL,
  `msg_subject` varchar(255) DEFAULT NULL,
  `msg_detail` text,
  `sender` varchar(100) DEFAULT NULL,
  `status` varchar(20) DEFAULT NULL,
  `school_id` varchar(10) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `nems_school`
--

CREATE TABLE `nems_school` (
  `school_id` int(4) UNSIGNED ZEROFILL NOT NULL,
  `state_id` varchar(255) DEFAULT NULL,
  `lga_id` varchar(255) DEFAULT NULL,
  `user_name` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `school_name` varchar(255) DEFAULT NULL,
  `address` text,
  `educator_name` varchar(255) DEFAULT NULL,
  `educator_phone` varchar(100) DEFAULT NULL,
  `create_date` datetime DEFAULT NULL,
  `logo` varchar(255) DEFAULT NULL,
  `curr_session` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `nems_school`
--

INSERT INTO `nems_school` (`school_id`, `state_id`, `lga_id`, `user_name`, `password`, `school_name`, `address`, `educator_name`, `educator_phone`, `create_date`, `logo`, `curr_session`) VALUES
(0027, '', '1', 'admin', 'admin', 'Default School Name', 'Lagos Nigeria', '', '', '2010-12-20 21:15:35', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `nems_student`
--

CREATE TABLE `nems_student` (
  `student_id` int(4) UNSIGNED ZEROFILL NOT NULL,
  `piks` varchar(255) DEFAULT NULL,
  `reg_no` varchar(255) DEFAULT NULL,
  `school_id` varchar(255) DEFAULT NULL,
  `first_name` varchar(255) DEFAULT NULL,
  `other_name` varchar(255) DEFAULT NULL,
  `sex` varchar(255) DEFAULT NULL,
  `DOB` varchar(255) DEFAULT NULL,
  `contact_address` text,
  `phone_number` varchar(255) DEFAULT NULL,
  `email_address` varchar(255) NOT NULL,
  `state_of_origin` varchar(255) DEFAULT NULL,
  `nationality` varchar(255) DEFAULT NULL,
  `admission_date` varchar(255) DEFAULT NULL,
  `adm_month` varchar(255) DEFAULT NULL,
  `class_subject` varchar(255) DEFAULT NULL,
  `create_date` date DEFAULT NULL,
  `fees_paid` int(10) DEFAULT '0',
  `med_record` text,
  `more_comment` text,
  `parent_name` varchar(255) DEFAULT NULL,
  `parent_address` text,
  `parent_phone` varchar(50) DEFAULT NULL,
  `sch_comment` text,
  `status` varchar(100) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `nems_subject`
--

CREATE TABLE `nems_subject` (
  `subject_id` int(12) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `school_id` varchar(255) DEFAULT NULL,
  `syllabus` text
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `nems_teacher`
--

CREATE TABLE `nems_teacher` (
  `teacher_id` int(15) NOT NULL,
  `pic_name` varchar(255) DEFAULT NULL,
  `school_id` varchar(255) DEFAULT NULL,
  `username` varchar(255) DEFAULT NULL,
  `PIN` varchar(255) DEFAULT NULL,
  `first_name` varchar(255) DEFAULT NULL,
  `other_name` varchar(255) DEFAULT NULL,
  `sex` varchar(255) DEFAULT NULL,
  `DOB` varchar(255) DEFAULT NULL,
  `contact_address` text,
  `phone` varchar(255) DEFAULT NULL,
  `state_of_origin` varchar(255) DEFAULT NULL,
  `qualification` varchar(255) DEFAULT NULL,
  `session` varchar(255) DEFAULT NULL,
  `date_emp` varchar(50) NOT NULL,
  `category` varchar(255) DEFAULT NULL,
  `class_manage` varchar(100) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `nems_teacher`
--

INSERT INTO `nems_teacher` (`teacher_id`, `pic_name`, `school_id`, `username`, `PIN`, `first_name`, `other_name`, `sex`, `DOB`, `contact_address`, `phone`, `state_of_origin`, `qualification`, `session`, `date_emp`, `category`, `class_manage`) VALUES
(29, NULL, '0027', NULL, 'admin', 'admin', 'onuorah', 'MALE', NULL, '23', 'ola@y.com', NULL, NULL, NULL, '', NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `nems_test_mgt`
--

CREATE TABLE `nems_test_mgt` (
  `id` int(10) NOT NULL,
  `sch_id` varchar(50) DEFAULT NULL,
  `tutor_id` varchar(50) DEFAULT NULL,
  `test_id` varchar(50) DEFAULT NULL,
  `student_id` varchar(50) DEFAULT NULL,
  `date_approve` varchar(50) NOT NULL,
  `test_status` varchar(50) NOT NULL,
  `taken_test_batch_no` varchar(50) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Indexes for dumped tables
--

--
-- Indexes for table `backup_record`
--
ALTER TABLE `backup_record`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `j_nems_accesskey_request`
--
ALTER TABLE `j_nems_accesskey_request`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `j_nems_deadline`
--
ALTER TABLE `j_nems_deadline`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `j_nems_instruction`
--
ALTER TABLE `j_nems_instruction`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `j_nems_limit`
--
ALTER TABLE `j_nems_limit`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `j_nems_post`
--
ALTER TABLE `j_nems_post`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `j_nems_question`
--
ALTER TABLE `j_nems_question`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `j_nems_register`
--
ALTER TABLE `j_nems_register`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `j_nems_result`
--
ALTER TABLE `j_nems_result`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `j_nems_result_list`
--
ALTER TABLE `j_nems_result_list`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `j_nems_timer`
--
ALTER TABLE `j_nems_timer`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `j_pin`
--
ALTER TABLE `j_pin`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `nems_class`
--
ALTER TABLE `nems_class`
  ADD PRIMARY KEY (`class_id`);

--
-- Indexes for table `nems_class_subject`
--
ALTER TABLE `nems_class_subject`
  ADD PRIMARY KEY (`cs_id`);

--
-- Indexes for table `nems_message`
--
ALTER TABLE `nems_message`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `nems_school`
--
ALTER TABLE `nems_school`
  ADD PRIMARY KEY (`school_id`);

--
-- Indexes for table `nems_student`
--
ALTER TABLE `nems_student`
  ADD PRIMARY KEY (`student_id`);

--
-- Indexes for table `nems_subject`
--
ALTER TABLE `nems_subject`
  ADD PRIMARY KEY (`subject_id`);

--
-- Indexes for table `nems_teacher`
--
ALTER TABLE `nems_teacher`
  ADD PRIMARY KEY (`teacher_id`);

--
-- Indexes for table `nems_test_mgt`
--
ALTER TABLE `nems_test_mgt`
  ADD PRIMARY KEY (`id`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `backup_record`
--
ALTER TABLE `backup_record`
  MODIFY `id` int(15) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `j_nems_accesskey_request`
--
ALTER TABLE `j_nems_accesskey_request`
  MODIFY `id` int(10) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `j_nems_deadline`
--
ALTER TABLE `j_nems_deadline`
  MODIFY `id` int(10) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `j_nems_instruction`
--
ALTER TABLE `j_nems_instruction`
  MODIFY `id` int(10) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `j_nems_limit`
--
ALTER TABLE `j_nems_limit`
  MODIFY `id` int(10) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `j_nems_post`
--
ALTER TABLE `j_nems_post`
  MODIFY `id` int(10) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `j_nems_question`
--
ALTER TABLE `j_nems_question`
  MODIFY `id` int(10) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `j_nems_register`
--
ALTER TABLE `j_nems_register`
  MODIFY `id` int(10) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `j_nems_result`
--
ALTER TABLE `j_nems_result`
  MODIFY `id` int(10) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `j_nems_result_list`
--
ALTER TABLE `j_nems_result_list`
  MODIFY `id` int(10) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `j_nems_timer`
--
ALTER TABLE `j_nems_timer`
  MODIFY `id` int(10) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `j_pin`
--
ALTER TABLE `j_pin`
  MODIFY `id` int(10) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=106;
--
-- AUTO_INCREMENT for table `nems_class`
--
ALTER TABLE `nems_class`
  MODIFY `class_id` int(10) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `nems_class_subject`
--
ALTER TABLE `nems_class_subject`
  MODIFY `cs_id` int(15) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `nems_message`
--
ALTER TABLE `nems_message`
  MODIFY `id` int(10) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `nems_school`
--
ALTER TABLE `nems_school`
  MODIFY `school_id` int(4) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=28;
--
-- AUTO_INCREMENT for table `nems_student`
--
ALTER TABLE `nems_student`
  MODIFY `student_id` int(4) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `nems_subject`
--
ALTER TABLE `nems_subject`
  MODIFY `subject_id` int(12) NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `nems_teacher`
--
ALTER TABLE `nems_teacher`
  MODIFY `teacher_id` int(15) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=30;
--
-- AUTO_INCREMENT for table `nems_test_mgt`
--
ALTER TABLE `nems_test_mgt`
  MODIFY `id` int(10) NOT NULL AUTO_INCREMENT;

