DROP TABLE IF EXISTS backup_record;

CREATE TABLE `backup_record` (
  `id` int(15) NOT NULL AUTO_INCREMENT,
  `detail` varchar(255) NOT NULL,
  `school_id` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS j_nems_accesskey_request;

CREATE TABLE `j_nems_accesskey_request` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `date_request` varchar(100) DEFAULT NULL,
  `test_id` varchar(50) DEFAULT NULL,
  `student_id` varchar(50) DEFAULT NULL,
  `enter_key` varchar(50) DEFAULT NULL,
  `status` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS j_nems_deadline;

CREATE TABLE `j_nems_deadline` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `status` varchar(100) DEFAULT NULL,
  `post_id` varchar(100) DEFAULT NULL,
  `com_id` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO j_nems_deadline VALUES("1","1","1","0027");



DROP TABLE IF EXISTS j_nems_instruction;

CREATE TABLE `j_nems_instruction` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `instruction` text NOT NULL,
  `com_id` varchar(50) DEFAULT NULL,
  `post_id` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO j_nems_instruction VALUES("1","
\n<hr>
\n<br />
\n1. 50% Correct Answer is the pass mark <br />
\n2. You have 60 minutes to complete the test <br />
\n3. Do not click the browser refresh button when taken the test <br />
\n4. After submitting do not click the browser back button <br />
\n5. Cheating is not allowed. <br />
\n<br />
\nThank you","0027","1");



DROP TABLE IF EXISTS j_nems_limit;

CREATE TABLE `j_nems_limit` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `percenta` varchar(100) NOT NULL,
  `com_id` varchar(50) NOT NULL,
  `post_id` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO j_nems_limit VALUES("1","50","0027","1");



DROP TABLE IF EXISTS j_nems_post;

CREATE TABLE `j_nems_post` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `post_name` varchar(255) NOT NULL,
  `detail` text NOT NULL,
  `com_id` varchar(50) NOT NULL,
  `test_type` varchar(20) DEFAULT NULL,
  `num_attempt` varchar(50) NOT NULL,
  `user_id` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO j_nems_post VALUES("1","Web Dev","","0027","open","Multiple times","select");



DROP TABLE IF EXISTS j_nems_question;

CREATE TABLE `j_nems_question` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `test_id` varchar(20) DEFAULT NULL,
  `question` text,
  `question_img` varchar(255) NOT NULL,
  `optionA` varchar(20) NOT NULL,
  `optionA_detail` text,
  `optionA_img` varchar(255) NOT NULL,
  `optionB` varchar(20) DEFAULT NULL,
  `optionB_detail` text,
  `optionB_img` varchar(255) NOT NULL,
  `optionC` varchar(20) DEFAULT NULL,
  `optionC_detail` text,
  `optionC_img` varchar(255) NOT NULL,
  `optionD` varchar(20) DEFAULT NULL,
  `optionD_detail` text,
  `optionD_img` varchar(255) NOT NULL,
  `correct_option` varchar(20) DEFAULT NULL,
  `correct_option_detail` text,
  `ans_img` varchar(255) NOT NULL,
  `com_id` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

INSERT INTO j_nems_question VALUES("1","1","<p>What is an algorithm&nbsp;</p>","","A","<p>step for solving a problem</p>","","B","<p>list of problems</p>","","C","<p>computer language</p>","","D","<p>best problems unsolved</p>","","A","","","0027"),
("2","1","<p>What is a loop</p>","","A","<p>steps to solving problems</p>","","B","<p>repeation of steps</p>","","C","<p>making decision on steps</p>","","D","<p>going through a step forever</p>","","B","","","0027");



DROP TABLE IF EXISTS j_nems_register;

CREATE TABLE `j_nems_register` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `email` varchar(200) NOT NULL,
  `password` varchar(200) NOT NULL,
  `date_created` varchar(100) NOT NULL,
  `test_date` varchar(100) NOT NULL,
  `surname` varchar(255) NOT NULL,
  `othername` varchar(255) NOT NULL,
  `gender` varchar(50) NOT NULL,
  `dob` varchar(50) NOT NULL,
  `phone` varchar(50) NOT NULL,
  `address` text NOT NULL,
  `state_of_origin` varchar(255) NOT NULL,
  `sch_attended` text NOT NULL,
  `qualification_field_of_study` varchar(255) NOT NULL,
  `year_of_graduation` varchar(200) NOT NULL,
  `post_apply_for` varchar(255) NOT NULL,
  `status` varchar(10) NOT NULL,
  `com_id` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS j_nems_result;

CREATE TABLE `j_nems_result` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `user_email` varchar(255) NOT NULL,
  `question_id` varchar(10) NOT NULL,
  `user_answer` varchar(10) NOT NULL,
  `test_summary` text NOT NULL,
  `com_id` varchar(50) NOT NULL,
  `date_taken` varchar(40) DEFAULT NULL,
  `batch_num_val` varchar(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

INSERT INTO j_nems_result VALUES("1","0002","1","A","","0027","","14"),
("2","0002","2","C","","0027","","15"),
("3","0002","2","C","","0027","","16");



DROP TABLE IF EXISTS j_nems_result_list;

CREATE TABLE `j_nems_result_list` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `date_taken` varchar(20) DEFAULT NULL,
  `test_name` varchar(255) DEFAULT NULL,
  `test_id` varchar(20) DEFAULT NULL,
  `student_id` varchar(20) DEFAULT NULL,
  `batch_num` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=latin1;

INSERT INTO j_nems_result_list VALUES("1","1736234508","","1","0002","1"),
("2","1736234609","","1","0002","2"),
("3","1736234653","","1","0002","3"),
("4","1736235149","","1","0002","4"),
("5","1736235192","","1","0002","5"),
("6","1736235295","","1","0002","6"),
("7","1736235331","","1","0002","7"),
("8","1736235340","","1","0002","8"),
("9","1736235360","","1","0002","9"),
("10","1736235375","","1","0002","10"),
("11","1736235411","","1","0002","11"),
("12","1736235429","","1","0002","12"),
("13","1736235468","","1","0002","13"),
("14","1736235488","1736235521","1","0002","14"),
("15","1736235528","1736235528","1","0002","15"),
("16","1736235595","1736235595","1","0002","16");



DROP TABLE IF EXISTS j_nems_timer;

CREATE TABLE `j_nems_timer` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `time_set` varchar(100) DEFAULT NULL,
  `post_id` varchar(100) DEFAULT NULL,
  `com_id` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO j_nems_timer VALUES("1","1800","1","0027");



DROP TABLE IF EXISTS j_pin;

CREATE TABLE `j_pin` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `pin` varchar(50) NOT NULL,
  `batch` varchar(10) NOT NULL,
  `status` varchar(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=106 DEFAULT CHARSET=latin1;

INSERT INTO j_pin VALUES("1","fkMfmHMoD2","1",""),
("2","92TivVuZVg","1",""),
("3","g21LyVRFdD","1",""),
("4","2FABGZvQln","1",""),
("5","kM90SqGDwc","1",""),
("6","yDqWzUKPhK","2",""),
("7","RchT8xExoN","2",""),
("8","0qZuqLLxwg","2",""),
("9","3qmaI8xa56","2",""),
("10","bu0lQSPhEv","2",""),
("11","nVb81HwXBC","2","1736234005"),
("12","hGr7xzobTj","2",""),
("13","Ohs7wmNJTV","2",""),
("14","1lKUIHrOZ0","2",""),
("15","NzpZbG6Qr6","2",""),
("16","DkUj6Cqg7s","2",""),
("17","kqL4uMD9dM","2",""),
("18","PWnpV9j810","2",""),
("19","RUJdne8ZG2","2",""),
("20","O49OTFBwVu","2",""),
("21","nD2Ll7OcOs","2",""),
("22","l2FAdYd0xf","2",""),
("23","kGTyl4n858","2",""),
("24","AGUmCrFH47","2",""),
("25","HE1WQ94CrG","2",""),
("26","jmlclUUcft","2",""),
("27","WCDLPXA0na","2",""),
("28","HVXI4Iozi8","2",""),
("29","2dsmKBa9Qc","2",""),
("30","uGbZ3I6rVr","2",""),
("31","svIAAFvnjS","2",""),
("32","Uw0DZfvSmf","2",""),
("33","957MNeQxLM","2",""),
("34","DKUI68AtjU","2",""),
("35","C3SMmUTZE1","2",""),
("36","WeQQ7KMl0f","2",""),
("37","N0JWKNRyXa","2",""),
("38","vji7eV54aC","2",""),
("39","a2S6UtuA9l","2",""),
("40","yPd7c0XL0R","2",""),
("41","IK3Al2YWb7","2",""),
("42","O74WcPmYej","2",""),
("43","SdthZ52WxA","2",""),
("44","v1QbZKLQ4P","2",""),
("45","E1QulIUram","2",""),
("46","lUZWLB9WfK","2",""),
("47","uio4lviMzw","2",""),
("48","yAuOfJYmYV","2",""),
("49","mCQntzqOGF","2",""),
("50","QrOTEZdHYG","2",""),
("51","K4peIt1R0S","2",""),
("52","qhVKIIl3tS","2",""),
("53","BgN0wliMtL","2",""),
("54","2sivDKj1aR","2",""),
("55","ohfvRLXVAq","2",""),
("56","TPSK8rBGis","2",""),
("57","6It7dOe8hq","2",""),
("58","HJayrCbDz1","2",""),
("59","cFGFx5RK3T","2",""),
("60","G06xhEwZdp","2",""),
("61","DIBtjH1BSo","2",""),
("62","zZbMQmzjWW","2",""),
("63","TYrques3b2","2",""),
("64","zxmSS6PIYs","2",""),
("65","W1WPxLoWYq","2",""),
("66","pZ6WAIeN1k","2",""),
("67","eYiysVwBIC","2",""),
("68","icnxGyhDjo","2",""),
("69","LofVGL6Tmf","2",""),
("70","XuFMprVPyY","2",""),
("71","ZoZOcVO9on","2",""),
("72","BIVfsKDuYW","2",""),
("73","RygwssTdLC","2",""),
("74","XeD24inaiC","2",""),
("75","SZgVsY3qY4","2",""),
("76","fRKLWqD0KQ","2",""),
("77","ZhJlEyvEXj","2",""),
("78","aXKuj0mz0Z","2",""),
("79","FwSE0P0cbr","2",""),
("80","YmAPSl2XkS","2",""),
("81","TjqaYQJXE2","2",""),
("82","lqKRTkCLqR","2",""),
("83","7JzKyepeOe","2",""),
("84","xZcc2gA5wM","2",""),
("85","jo4Kd4hSDA","2",""),
("86","eopUy1UwjY","2",""),
("87","Xn6YTX2eAd","2",""),
("88","GtlC9V292i","2",""),
("89","0hqN5YUaDG","2",""),
("90","ABtp3PXAp4","2",""),
("91","Wce3KICZf7","2",""),
("92","aALRY48TDa","2",""),
("93","JJf6minzp5","2",""),
("94","9NG49vxHsV","2",""),
("95","PXGLTiUezH","2",""),
("96","K4cDgtD44a","2",""),
("97","dtgoNOrQHy","2",""),
("98","FJMFzOoCdg","2",""),
("99","mndP2qFIhI","2",""),
("100","9EpJLRhq62","2",""),
("101","ehgq7fPJgO","2",""),
("102","UaxW4tg5rQ","2",""),
("103","ifB1YRDc8U","2",""),
("104","978SdZPHsw","2",""),
("105","wSXW5mjZRD","2","");



DROP TABLE IF EXISTS nems_class;

CREATE TABLE `nems_class` (
  `class_id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `school_id` varchar(50) NOT NULL,
  PRIMARY KEY (`class_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO nems_class VALUES("1","CODING","0027");



DROP TABLE IF EXISTS nems_class_subject;

CREATE TABLE `nems_class_subject` (
  `cs_id` int(15) NOT NULL AUTO_INCREMENT,
  `class_id` varchar(255) DEFAULT NULL,
  `subject_id` varchar(255) DEFAULT NULL,
  `school_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`cs_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS nems_message;

CREATE TABLE `nems_message` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `date_sent` varchar(10) DEFAULT NULL,
  `recipient_id` varchar(10) DEFAULT NULL,
  `recipient_type` varchar(10) DEFAULT NULL,
  `msg_subject` varchar(255) DEFAULT NULL,
  `msg_detail` text,
  `sender` varchar(100) DEFAULT NULL,
  `status` varchar(20) DEFAULT NULL,
  `school_id` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

INSERT INTO nems_message VALUES("1","1","","","","","","","0027"),
("2","2","","","","","","","0027");



DROP TABLE IF EXISTS nems_school;

CREATE TABLE `nems_school` (
  `school_id` int(4) unsigned zerofill NOT NULL AUTO_INCREMENT,
  `state_id` varchar(255) DEFAULT NULL,
  `lga_id` varchar(255) DEFAULT NULL,
  `user_name` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `school_name` varchar(255) DEFAULT NULL,
  `address` text,
  `educator_name` varchar(255) DEFAULT NULL,
  `educator_phone` varchar(100) DEFAULT NULL,
  `create_date` datetime DEFAULT NULL,
  `logo` varchar(255) DEFAULT NULL,
  `curr_session` varchar(50) NOT NULL,
  PRIMARY KEY (`school_id`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=latin1;

INSERT INTO nems_school VALUES("0027","","1","admin","admin","Default School Name","Lagos Nigeria","","","2010-12-20 21:15:35","","nVb81HwXBC");



DROP TABLE IF EXISTS nems_student;

CREATE TABLE `nems_student` (
  `student_id` int(4) unsigned zerofill NOT NULL AUTO_INCREMENT,
  `piks` varchar(255) DEFAULT NULL,
  `reg_no` varchar(255) DEFAULT NULL,
  `school_id` varchar(255) DEFAULT NULL,
  `first_name` varchar(255) DEFAULT NULL,
  `other_name` varchar(255) DEFAULT NULL,
  `sex` varchar(255) DEFAULT NULL,
  `DOB` varchar(255) DEFAULT NULL,
  `contact_address` text,
  `phone_number` varchar(255) DEFAULT NULL,
  `email_address` varchar(255) NOT NULL,
  `state_of_origin` varchar(255) DEFAULT NULL,
  `nationality` varchar(255) DEFAULT NULL,
  `admission_date` varchar(255) DEFAULT NULL,
  `adm_month` varchar(255) DEFAULT NULL,
  `class_subject` varchar(255) DEFAULT NULL,
  `create_date` date DEFAULT NULL,
  `fees_paid` int(10) DEFAULT '0',
  `med_record` text,
  `more_comment` text,
  `parent_name` varchar(255) DEFAULT NULL,
  `parent_address` text,
  `parent_phone` varchar(50) DEFAULT NULL,
  `sch_comment` text,
  `status` varchar(100) NOT NULL,
  PRIMARY KEY (`student_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

INSERT INTO nems_student VALUES("0001","","1","0027","ade","kunle","Male","","","","","","Nigeria","","NOT VERIFIED","","2025-01-07","0","","","","","","",""),
("0002","","11","0027","ade","kunle","Male","","","","","","Nigeria","","NOT VERIFIED","1","2025-01-07","0","","","","","","","");



DROP TABLE IF EXISTS nems_subject;

CREATE TABLE `nems_subject` (
  `subject_id` int(12) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `school_id` varchar(255) DEFAULT NULL,
  `syllabus` text,
  PRIMARY KEY (`subject_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS nems_teacher;

CREATE TABLE `nems_teacher` (
  `teacher_id` int(15) NOT NULL AUTO_INCREMENT,
  `pic_name` varchar(255) DEFAULT NULL,
  `school_id` varchar(255) DEFAULT NULL,
  `username` varchar(255) DEFAULT NULL,
  `PIN` varchar(255) DEFAULT NULL,
  `first_name` varchar(255) DEFAULT NULL,
  `other_name` varchar(255) DEFAULT NULL,
  `sex` varchar(255) DEFAULT NULL,
  `DOB` varchar(255) DEFAULT NULL,
  `contact_address` text,
  `phone` varchar(255) DEFAULT NULL,
  `state_of_origin` varchar(255) DEFAULT NULL,
  `qualification` varchar(255) DEFAULT NULL,
  `session` varchar(255) DEFAULT NULL,
  `date_emp` varchar(50) NOT NULL,
  `category` varchar(255) DEFAULT NULL,
  `class_manage` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`teacher_id`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=latin1;

INSERT INTO nems_teacher VALUES("29","","0027","","admin","admin","onuorah","MALE","","23","ola@y.com","","","","","","");



DROP TABLE IF EXISTS nems_test_mgt;

CREATE TABLE `nems_test_mgt` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `sch_id` varchar(50) DEFAULT NULL,
  `tutor_id` varchar(50) DEFAULT NULL,
  `test_id` varchar(50) DEFAULT NULL,
  `student_id` varchar(50) DEFAULT NULL,
  `date_approve` varchar(50) NOT NULL,
  `test_status` varchar(50) NOT NULL,
  `taken_test_batch_no` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




